/**
* \file: PluginManager.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Utility
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef UTILITY_PLUGINMANAGER_H
#define UTILITY_PLUGINMANAGER_H

#include <string>
#include <vector>

namespace adit { namespace utility {

typedef bool (*PluginEntryPointCallbackFn)(void* inEntryPointFn);
typedef void (*PluginExitPointCallbackFn)(void* inExitPointFn);

class PluginManager
{
public:
    ~PluginManager();

    bool load(const std::string& inName, const std::string& inEntryPoint,
            PluginEntryPointCallbackFn inEntryPointCallback, const std::string& inExitPoint,
            PluginExitPointCallbackFn inExitPointCallback = justCall);
    void unloadAll();

private:
    struct Library
    {
        void* Handle;
        std::string Name;
        void* ExitPoint;
        PluginExitPointCallbackFn ExitCallback;

        Library();
    };

    std::vector<Library> libraries;

    inline static void justCall(void* inFn) { auto fn = reinterpret_cast<void* (*)()>(inFn); fn(); }
};

} } /* namespace adit { namespace utility */

#endif /* UTILITY_PLUGINMANAGER_H */
